/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.jade;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.AgriGrowthResponse;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class AgriCraftJadePlugin
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)CropBlockComponentProvider.INSTANCE, CropBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)SoilComponentProvider.INSTANCE, class_2248.class);
    }

    public static class CropBlockComponentProvider
    implements IBlockComponentProvider {
        public static final CropBlockComponentProvider INSTANCE = new CropBlockComponentProvider();
        private static final class_2960 ID = new class_2960("agricraft", "crop_block");

        private CropBlockComponentProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            class_2586 class_25862 = blockAccessor.getBlockEntity();
            if (class_25862 instanceof AgriCrop) {
                AgriCrop crop = (AgriCrop)class_25862;
                if (crop.hasPlant()) {
                    iTooltip.add((class_2561)class_2561.method_43469((String)"agricraft.tooltip.jade.growth", (Object[])new Object[]{crop.getGrowthPercent() * 100.0}));
                    if (blockAccessor.getPlayer().method_5715()) {
                        AgriGrowthResponse response;
                        iTooltip.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.jade.species").method_10852(LangUtils.plantName(crop.getGenome().getSpeciesGene().getTrait())));
                        AgriStatRegistry.getInstance().stream().filter(stat -> !stat.isHidden()).map(stat -> crop.getGenome().getStatGene((AgriStat)stat)).sorted(Comparator.comparing(p -> p.getGene().getId())).map(genePair -> class_2561.method_43469((String)("agricraft.tooltip.jade.stat." + genePair.getGene().getId()), (Object[])new Object[]{genePair.getTrait()})).forEach(arg_0 -> ((ITooltip)iTooltip).add(arg_0));
                        if (crop.method_10997().field_9236) {
                            crop.method_10997().method_8533();
                        }
                        iTooltip.add((class_2561)class_2561.method_43471((String)("agricraft.tooltip.magnifying.requirement." + ((response = crop.getFertilityResponse()).isLethal() ? "lethal" : (response.isFertile() ? "fertile" : "not_fertile")))));
                        if (!response.isFertile()) {
                            int strength = crop.getGenome().getStrength();
                            AgriGrowthConditionRegistry.getInstance().stream().filter(condition -> !condition.check(crop, crop.method_10997(), crop.method_11016(), strength).isFertile()).forEach(condition -> condition.notMetDescription(arg_0 -> ((ITooltip)iTooltip).add(arg_0)));
                        }
                    }
                } else {
                    iTooltip.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.no_plant"));
                }
                if (crop.hasWeeds()) {
                    iTooltip.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.weeds").method_10852(LangUtils.weedName(crop.getWeedId())));
                    if (blockAccessor.getPlayer().method_5715()) {
                        iTooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43469((String)"agricraft.tooltip.magnifying.growth", (Object[])new Object[]{crop.getWeedGrowthStage().index() + 1, crop.getWeedGrowthStage().total()})));
                    }
                }
            }
        }

        public class_2960 getUid() {
            return ID;
        }
    }

    public static class SoilComponentProvider
    implements IBlockComponentProvider {
        public static final SoilComponentProvider INSTANCE = new SoilComponentProvider();
        private static final class_2960 ID = new class_2960("agricraft", "soil");

        private SoilComponentProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            Optional<AgriSoil> soil = AgriApi.getSoil((class_1922)blockAccessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getLevel().method_30349());
            if (soil.isPresent() && blockAccessor.getPlayer().method_5715()) {
                AgriSoil soil1 = soil.get();
                iTooltip.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.soil.humidity").method_10852((class_2561)class_2561.method_43471((String)("agricraft.soil.humidity." + soil1.humidity().name().toLowerCase()))));
                iTooltip.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.soil.acidity").method_10852((class_2561)class_2561.method_43471((String)("agricraft.soil.acidity." + soil1.acidity().name().toLowerCase()))));
                iTooltip.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.magnifying.soil.nutrients").method_10852((class_2561)class_2561.method_43471((String)("agricraft.soil.nutrients." + soil1.nutrients().name().toLowerCase()))));
            }
        }

        public class_2960 getUid() {
            return ID;
        }
    }
}

